package ru.yandex.intranet.d.model.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ImmutableMap;

/**
 * Resource mapping to related resources.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class RelatedResourceMapping {
    private final Map<String, RelatedCoefficient> relatedCoefficientMap;

    @JsonCreator
    public RelatedResourceMapping(Map<String, RelatedCoefficient> relatedCoefficientMap) {
        this.relatedCoefficientMap = ImmutableMap.copyOf(relatedCoefficientMap);
    }

    public Map<String, RelatedCoefficient> getRelatedCoefficientMap() {
        return relatedCoefficientMap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelatedResourceMapping that = (RelatedResourceMapping) o;
        return Objects.equals(relatedCoefficientMap, that.relatedCoefficientMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(relatedCoefficientMap);
    }

    @Override
    public String toString() {
        return "RelatedResourceMapping{" +
                "relatedCoefficientMap=" + relatedCoefficientMap +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, RelatedCoefficient> relatedCoefficientMap = new HashMap<>();

        public Builder addRelatedCoefficient(String id, RelatedCoefficient relatedCoefficient) {
            relatedCoefficientMap.put(id, relatedCoefficient);
            return this;
        }

        public Builder relatedCoefficientMap(Map<String, RelatedCoefficient> relatedCoefficientMap) {
            this.relatedCoefficientMap = relatedCoefficientMap;
            return this;
        }

        public RelatedResourceMapping build() {
            Objects.requireNonNull(relatedCoefficientMap);
            return new RelatedResourceMapping(relatedCoefficientMap);
        }
    }
}
