package ru.yandex.intranet.d.model.providers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Usage mode.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class UsageMode {
    UNDEFINED,
    TIME_SERIES,
    UNUSED_ESTIMATION_VALUE;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): UsageMode? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
