package ru.yandex.intranet.d.model.resources;

import java.util.Objects;

import ru.yandex.intranet.d.model.TenantId;

/**
 * ResourceBaseIdentity
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public final class ResourceBaseIdentity {
    private final TenantId tenantId;
    private final String providerId;
    private final String resourceTypeId;

    public ResourceBaseIdentity(TenantId tenantId, String providerId, String resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
        this.tenantId = tenantId;
        this.providerId = providerId;
    }

    public ResourceBaseIdentity(ResourceModel resource) {
        this(resource.getTenantId(), resource.getProviderId(), resource.getResourceTypeId());
    }

    public String getResourceTypeId() {
        return resourceTypeId;
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public String getProviderId() {
        return providerId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceBaseIdentity that = (ResourceBaseIdentity) o;
        return Objects.equals(resourceTypeId, that.resourceTypeId)
                && Objects.equals(tenantId, that.tenantId)
                && Objects.equals(providerId, that.providerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceTypeId, tenantId, providerId);
    }

    @Override
    public String toString() {
        return "ResourceBaseIdentity{" +
                "resourceTypeId='" + resourceTypeId + '\'' +
                ", tenantId=" + tenantId +
                ", providerId='" + providerId + '\'' +
                '}';
    }
}
