package ru.yandex.intranet.d.model.resources.types

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.intranet.d.kotlin.ProviderId
import ru.yandex.intranet.d.kotlin.ResourceTypeId
import ru.yandex.intranet.d.model.TenantId

@JsonIgnoreProperties(ignoreUnknown = true)
data class ExchangeableResourceTypeModel @JsonCreator constructor(
    val key: ExchangeableResourceTypeKey,
    val numerator: Long,
    val denominator: Long,
    val available_segments: ExchangeableResourceTypeSegments
)

data class ExchangeableResourceTypeKey(
    val tenantId: TenantId,
    val providerId: ProviderId,
    val toResourceTypeId: ResourceTypeId,
    val fromResourceTypeId: ResourceTypeId
)
