package ru.yandex.intranet.d.model.resources.types;

import java.util.Objects;

/**
 * ResourceTypeId.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 18.11.2020
 */
public final class ResourceTypeId {
    private final String value;

    public ResourceTypeId(String value) {
        this.value = value;
    }

    public static ResourceTypeId from(ResourceTypeModel model) {
        return new ResourceTypeId(model.getId());
    }

    public String getValue() {
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceTypeId that = (ResourceTypeId) o;
        return Objects.equals(value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public String toString() {
        return "ResourceTypeId: " + value;
    }
}
