package ru.yandex.intranet.d.model.services;

import java.util.Objects;

/**
 * Service Id with its parent Id.
 long*
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 03.11.2020
 */
public final class ServiceIdAndParentId {
    private final long serviceId;
    private final long parentId;

    public ServiceIdAndParentId(long serviceId, long parentId) {
        this.serviceId = serviceId;
        this.parentId = parentId;
    }

    public long getServiceId() {
        return serviceId;
    }

    public long getParentId() {
        return parentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServiceIdAndParentId that = (ServiceIdAndParentId) o;
        return serviceId == that.serviceId &&
                parentId == that.parentId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, parentId);
    }

    @Override
    public String toString() {
        return "ServiceIdAndParentId{" +
                "serviceId=" + serviceId +
                ", parentId=" + parentId +
                '}';
    }
}
