package ru.yandex.intranet.d.model.services;

import java.util.Objects;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Service with minimal fields subset.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ServiceMinimalModel {

    private final long id;
    private final String name;
    private final String nameEn;
    private final String slug;
    private final ServiceState state;
    private final ServiceReadOnlyState readOnlyState;
    private final boolean exportable;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public ServiceMinimalModel(@JsonProperty("id") long id,
                               @JsonProperty("name") String name,
                               @JsonProperty("nameEn") String nameEn,
                               @JsonProperty("slug") String slug,
                               @JsonProperty("state") ServiceState state,
                               @JsonProperty("readOnlyState") ServiceReadOnlyState readOnlyState,
                               @JsonProperty("exportable") boolean exportable) {
        this.id = id;
        this.name = name;
        this.nameEn = nameEn;
        this.slug = slug;
        this.state = state;
        this.readOnlyState = readOnlyState;
        this.exportable = exportable;
    }

    public ServiceMinimalModel(ServiceModel model) {
        this.id = model.getId();
        this.name = model.getName();
        this.nameEn = model.getNameEn();
        this.slug = model.getSlug();
        this.state = model.getState();
        this.readOnlyState = model.getReadOnlyState();
        this.exportable = model.getExportable();
    }

    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getNameEn() {
        return nameEn;
    }

    public String getSlug() {
        return slug;
    }

    public ServiceState getState() {
        return state;
    }

    @Nullable
    public ServiceReadOnlyState getReadOnlyState() {
        return readOnlyState;
    }

    public boolean isExportable() {
        return exportable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServiceMinimalModel that = (ServiceMinimalModel) o;
        return id == that.id && exportable == that.exportable && Objects.equals(name, that.name) &&
                Objects.equals(nameEn, that.nameEn) && Objects.equals(slug, that.slug) &&
                state == that.state && readOnlyState == that.readOnlyState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, nameEn, slug, state, readOnlyState, exportable);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
