package ru.yandex.intranet.d.model.services;

import java.util.HashMap;
import java.util.Map;

/**
 * Service readonly state.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public enum ServiceReadOnlyState {
    UNKNOWN(null),
    CREATING("creating"),
    MOVING("moving"),
    RENAMING("renaming"),
    DELETING("deleting"),
    CLOSING("closing");

    private final String key;

    ServiceReadOnlyState(String key) {
        this.key = key;
        Mapper.BY_KEY.put(key, this);
    }

    @Override
    public String toString() {
        return key;
    }

    public static ServiceReadOnlyState fromString(String value) {
        return Mapper.BY_KEY.getOrDefault(value, UNKNOWN);
    }

    private static final class Mapper {
        private static final Map<String, ServiceReadOnlyState> BY_KEY = new HashMap<>();
    }
}
