package ru.yandex.intranet.d.model.services;

import java.util.HashMap;
import java.util.Map;

/**
 * Service state.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public enum ServiceState {

    UNKNOWN(null),
    DEVELOP("develop"),
    SUPPORTED("supported"),
    NEED_INFO("needinfo"),
    CLOSED("closed"),
    DELETED("deleted");

    private final String key;

    ServiceState(String key) {
        this.key = key;
        Mapper.BY_KEY.put(key, this);
    }

    @Override
    public String toString() {
        return key;
    }

    public static ServiceState fromString(String value) {
        return Mapper.BY_KEY.getOrDefault(value, UNKNOWN);
    }

    private static final class Mapper {
        private static final Map<String, ServiceState> BY_KEY = new HashMap<>();
    }
}
