package ru.yandex.intranet.d.model.services;

import java.util.Objects;

import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

/**
 * Service with minimal fields for validation status.
 *
 * @author Evgenii Serov <evserov@yandex-team.ru>
 */
public final class ServiceWithStatesModel {

    private final long id;
    private final ServiceState state;
    private final ServiceReadOnlyState readOnlyState;
    private final boolean exportable;
    private final String slug;

    public ServiceWithStatesModel(long id, ServiceState state, ServiceReadOnlyState readOnlyState,
                                  boolean exportable, String slug) {
        this.id = id;
        this.state = state;
        this.readOnlyState = readOnlyState;
        this.exportable = exportable;
        this.slug = slug;
    }

    public long getId() {
        return id;
    }

    public ServiceState getState() {
        return state;
    }

    public ServiceReadOnlyState getReadOnlyState() {
        return readOnlyState;
    }

    public boolean isExportable() {
        return exportable;
    }

    public String getSlug() {
        return slug;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServiceWithStatesModel that = (ServiceWithStatesModel) o;
        return id == that.id &&
                exportable == that.exportable &&
                state == that.state &&
                readOnlyState == that.readOnlyState &&
                Objects.equals(slug, that.slug);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, state, readOnlyState, exportable, slug);
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.toString(this);
    }
}
