package ru.yandex.intranet.d.model.settings

import com.fasterxml.jackson.core.type.TypeReference

/**
 * Settings keys.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
sealed class SettingsKey<T: Any> private constructor(val id: String, val datatype: TypeReference<T>) {
    object KNOWN_PROVIDERS: SettingsKey<KnownProviders>("9fe9810e-3897-4be9-ab51-2fc7816a76f6", object: TypeReference<KnownProviders>() {})
    object YT_USAGE_SYNC_SETTINGS: SettingsKey<YtUsageSyncSettings>("90c63c9e-980d-4f7a-8924-a41a40a43e69", object: TypeReference<YtUsageSyncSettings>() {})
    object YP_USAGE_SYNC_SETTINGS: SettingsKey<YpUsageSyncSettings>("17de1510-b6ee-47eb-8fdc-110f0374cbd0", object: TypeReference<YpUsageSyncSettings>() {})
    object RATE_LIMITER_SETTINGS: SettingsKey<RateLimiterSettings>("3ba1c24a-88cd-4b3d-a032-c9deadcdee74", object: TypeReference<RateLimiterSettings>() {})
}
