package ru.yandex.intranet.d.model.settings

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties

/**
 * Yt usage sync settings.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class YpUsageSyncSettings @JsonCreator constructor(
    val cpuResourceType: String?,
    val preStableCpuResourceType: String?,
    val clusterSegmentation: String?,
    val nodeSegmentSegmentation: String?,
    val preStableClusterSegmentation: String?,
    val preStableNodeSegmentSegmentation: String?,
    val defaultNodeSegment: String?,
    val devNodeSegment: String?,
    val preStableDefaultNodeSegment: String?,
    val preStableDevNodeSegment: String?,
    val coresUnitsEnsemble: String?,
    val coresUnit: String?,
    val syncEnabled: Boolean?
)
