package ru.yandex.intranet.d.model.settings

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties

/**
 * Yt usage sync settings.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class YtUsageSyncSettings @JsonCreator constructor(
    val cpuStrongResourceType: String?,
    val poolTreeSegmentation: String?,
    val physicalPoolTreeSegment: String?,
    val clusterSegmentation: String?,
    val scopeSegmentation: String?,
    val computeScopeSegment: String?,
    val syncEnabled: Boolean?,
    val cpuMetricGridSpacingSeconds: Long?,
    val cpuMetricUnitsEnsemble: String?,
    val cpuMetricUnit: String?
)
