package ru.yandex.intranet.d.model.sync;

import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Errors.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 05-04-2021
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class Errors {
    private final String errorMessage;
    private final Map<String, String> details;
    private final String response; // Json

    @JsonCreator
    public Errors(
            String errorMessage,
            Map<String, String> details,
            String response
    ) {
        this.errorMessage = errorMessage;
        this.details = details;
        this.response = response;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public Map<String, String> getDetails() {
        return details;
    }

    public String getResponse() {
        return response;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Errors errors = (Errors) o;
        return Objects.equals(errorMessage, errors.errorMessage) &&
                Objects.equals(details, errors.details) &&
                Objects.equals(response, errors.response);
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorMessage, details, response);
    }

    @Override
    public String toString() {
        return "Errors{" +
                "errorMessage='" + errorMessage + '\'' +
                ", details=" + details +
                ", response='" + response + '\'' +
                '}';
    }
}
