package ru.yandex.intranet.d.model.sync;

import java.time.Duration;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * SyncStats.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 09-04-2021
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class SyncStats {
    private final Long accountsCount;
    private final Long quotasCount;
    private final Duration syncDuration;

    @JsonCreator
    public SyncStats(
            Long accountsCount,
            Long quotasCount,
            Duration syncDuration
    ) {
        this.accountsCount = accountsCount;
        this.quotasCount = quotasCount;
        this.syncDuration = syncDuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SyncStats syncStats = (SyncStats) o;
        return Objects.equals(accountsCount, syncStats.accountsCount) &&
                Objects.equals(quotasCount, syncStats.quotasCount) &&
                Objects.equals(syncDuration, syncStats.syncDuration);
    }

    public Long getAccountsCount() {
        return accountsCount;
    }

    public Long getQuotasCount() {
        return quotasCount;
    }

    public Duration getSyncDuration() {
        return syncDuration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountsCount, quotasCount, syncDuration);
    }

    @Override
    public String toString() {
        return "SyncStats{" +
                "accountsCount=" + accountsCount +
                ", quotasCount=" + quotasCount +
                ", syncDuration=" + syncDuration +
                '}';
    }
}
