package ru.yandex.intranet.d.model.transfers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Folders responsible.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class FoldersResponsible {

    private final Set<String> folderIds;
    private final Set<ServiceResponsible> responsible;

    @JsonCreator
    public FoldersResponsible(@JsonProperty("folderIds") Set<String> folderIds,
                              @JsonProperty("responsible") Set<ServiceResponsible> responsible) {
        this.folderIds = folderIds;
        this.responsible = responsible;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FoldersResponsible value) {
        return new Builder(value);
    }

    public Set<String> getFolderIds() {
        return folderIds;
    }

    public Set<ServiceResponsible> getResponsible() {
        return responsible;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FoldersResponsible that = (FoldersResponsible) o;
        return Objects.equals(folderIds, that.folderIds) &&
                Objects.equals(responsible, that.responsible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(folderIds, responsible);
    }

    @Override
    public String toString() {
        return "FoldersResponsible{" +
                "folderIds=" + folderIds +
                ", responsible=" + responsible +
                '}';
    }

    public static final class Builder {

        private final Set<String> folderIds = new HashSet<>();
        private final Set<ServiceResponsible> responsible = new HashSet<>();

        private Builder() {
        }

        private Builder(FoldersResponsible value) {
            this.folderIds.addAll(value.folderIds);
            this.responsible.addAll(value.responsible);
        }

        public Builder addFolderId(String id) {
            this.folderIds.add(id);
            return this;
        }

        public Builder addFolderIds(String... ids) {
            this.folderIds.addAll(Arrays.asList(ids));
            return this;
        }

        public Builder addFolderIds(Collection<? extends String> ids) {
            this.folderIds.addAll(ids);
            return this;
        }

        public Builder addResponsible(ServiceResponsible serviceResponsible) {
            this.responsible.add(serviceResponsible);
            return this;
        }

        public Builder addResponsible(ServiceResponsible... serviceResponsibles) {
            this.responsible.addAll(Arrays.asList(serviceResponsibles));
            return this;
        }

        public Builder addResponsible(Collection<? extends ServiceResponsible> serviceResponsibles) {
            this.responsible.addAll(serviceResponsibles);
            return this;
        }

        public FoldersResponsible build() {
            return new FoldersResponsible(folderIds, responsible);
        }

    }

}
