package ru.yandex.intranet.d.model.transfers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.intranet.d.kotlin.LoanId
import ru.yandex.intranet.d.model.loans.LoanDueDate

/**
 * Loan metadata.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class LoanMeta @JsonCreator constructor(
    val borrowDueDate: LoanDueDate?,
    val borrowLoanIds: Set<LoanId>?,
    val payOffLoanId: LoanId?,
    val operationType: LoanOperationType,
    val provideOverCommitReserve: Boolean?,
)
