package ru.yandex.intranet.d.model.transfers

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonValue

/**
 * Loan operation type.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
enum class LoanOperationType {
    BORROW,
    PAY_OFF;

    @JsonValue
    fun toJsonValue(): String {
        return name
    }

    companion object {
        @JsonCreator
        @JvmStatic
        fun fromJsonValue(value: String?): LoanOperationType? {
            if (value == null) {
                return null
            }
            return valueOf(value)
        }
    }

}
