package ru.yandex.intranet.d.model.transfers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

import ru.yandex.intranet.d.model.TenantId;

/**
 * PendingTransferRequestsModel.
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 */
public final class PendingTransferRequestsModel {
    private final TenantId tenantId;
    private final String requestId;

    public PendingTransferRequestsModel(@JsonProperty("tenantId") TenantId tenantId,
                                        @JsonProperty("requestId") String requestId) {
        this.tenantId = tenantId;
        this.requestId = requestId;
    }

    public static PendingTransferRequestsModel.Builder builder() {
        return new PendingTransferRequestsModel.Builder();
    }

    public TenantId getTenantId() {
        return tenantId;
    }

    public String getRequestId() {
        return requestId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PendingTransferRequestsModel that = (PendingTransferRequestsModel) o;
        return tenantId.equals(that.tenantId) && requestId.equals(that.requestId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tenantId, requestId);
    }

    @Override
    public String toString() {
        return "PendingTransferRequestsModel{" +
                "tenantId=" + tenantId +
                ", requestId='" + requestId + '\'' +
                '}';
    }

    public static class Builder {
        private TenantId tenantId;
        private String requestId;

        public Builder tenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public PendingTransferRequestsModel build() {
            Preconditions.checkNotNull(tenantId, "TenantId is required");
            Preconditions.checkNotNull(requestId, "RequestId is required");
            return new PendingTransferRequestsModel(tenantId, requestId);
        }
    }
}
