package ru.yandex.intranet.d.model.transfers

import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import ru.yandex.intranet.d.kotlin.AccountsSpacesId
import ru.yandex.intranet.d.kotlin.ProviderId

/**
 * Provision transfer. There is exactly no more than one ProvisionTransfer for a pair of accounts
 * because provider API allows to update atomically at most two accounts at once.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class ProvisionTransfer(
    val sourceAccountId: String,
    val destinationAccountId: String,
    val sourceFolderId: String,
    val destinationFolderId: String,
    val sourceServiceId: Long,
    val destinationServiceId: Long,
    val sourceAccountTransfers: Set<ResourceQuotaTransfer>,
    val destinationAccountTransfers: Set<ResourceQuotaTransfer>,
    val providerId: ProviderId,
    val accountsSpacesId: AccountsSpacesId?,
    val operationId: String?,
)
