package ru.yandex.intranet.d.model.transfers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;

/**
 * Reserve responsible.
 *
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ReserveResponsibleModel {
    private final Set<String> responsibleIds;
    private final String providerId;
    private final String folderId;
    private final long serviceId;

    @JsonCreator
    public ReserveResponsibleModel(Set<String> responsibleIds, String providerId, String folderId, long serviceId) {
        this.responsibleIds = responsibleIds;
        this.providerId = providerId;
        this.folderId = folderId;
        this.serviceId = serviceId;
    }

    public Set<String> getResponsibleIds() {
        return responsibleIds;
    }

    public String getProviderId() {
        return providerId;
    }

    public String getFolderId() {
        return folderId;
    }

    public long getServiceId() {
        return serviceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ReserveResponsibleModel that = (ReserveResponsibleModel) o;
        return serviceId == that.serviceId && Objects.equals(responsibleIds, that.responsibleIds)
                && Objects.equals(providerId, that.providerId) && Objects.equals(folderId, that.folderId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(responsibleIds, providerId, folderId, serviceId);
    }

    @Override
    public String toString() {
        return "ReserveResponsibleModel{" +
                "responsibleIds=" + responsibleIds +
                ", providerId='" + providerId + '\'' +
                ", folderId='" + folderId + '\'' +
                ", serviceId=" + serviceId +
                '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Set<String> responsibleIds = new HashSet<>();
        private String providerId;
        private String folderId;
        private Long serviceId;

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public Builder serviceId(Long serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder addResponsibleId(String id) {
            this.responsibleIds.add(id);
            return this;
        }

        public Builder addResponsibleIds(String... ids) {
            this.responsibleIds.addAll(Arrays.asList(ids));
            return this;
        }

        public Builder addResponsibleIds(Collection<? extends String> ids) {
            this.responsibleIds.addAll(ids);
            return this;
        }

        public ReserveResponsibleModel build() {
            return new ReserveResponsibleModel(
                    responsibleIds,
                    Preconditions.checkNotNull(providerId),
                    Preconditions.checkNotNull(folderId),
                    Preconditions.checkNotNull(serviceId)
            );
        }
    }
}
