package ru.yandex.intranet.d.model.transfers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

/**
 * Folders responsible.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ServiceResponsible {

    private final long serviceId;
    private final Set<String> responsibleIds;

    @JsonCreator
    public ServiceResponsible(@JsonProperty("serviceId") long serviceId,
                              @JsonProperty("responsibleIds") Set<String> responsibleIds) {
        this.serviceId = serviceId;
        this.responsibleIds = responsibleIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceResponsible value) {
        return new Builder(value);
    }

    public long getServiceId() {
        return serviceId;
    }

    public Set<String> getResponsibleIds() {
        return responsibleIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServiceResponsible that = (ServiceResponsible) o;
        return serviceId == that.serviceId &&
                Objects.equals(responsibleIds, that.responsibleIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serviceId, responsibleIds);
    }

    @Override
    public String toString() {
        return "ServiceResponsible{" +
                "serviceId=" + serviceId +
                ", responsibleIds=" + responsibleIds +
                '}';
    }

    public static final class Builder {

        private final Set<String> responsibleIds = new HashSet<>();

        private Long serviceId;

        private Builder() {
        }

        private Builder(ServiceResponsible value) {
            this.serviceId = value.serviceId;
            this.responsibleIds.addAll(value.responsibleIds);
        }

        public Builder serviceId(long serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder addResponsibleId(String id) {
            this.responsibleIds.add(id);
            return this;
        }

        public Builder addResponsibleIds(String... ids) {
            this.responsibleIds.addAll(Arrays.asList(ids));
            return this;
        }

        public Builder addResponsibleIds(Collection<? extends String> ids) {
            this.responsibleIds.addAll(ids);
            return this;
        }

        public ServiceResponsible build() {
            Preconditions.checkNotNull(serviceId, "ServiceId is required");
            return new ServiceResponsible(serviceId, responsibleIds);
        }

    }

}
