package ru.yandex.intranet.d.model.transfers;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.intranet.d.model.users.UserModel;
import ru.yandex.intranet.d.services.transfer.model.ResponsibleAndNotified;

/**
 * TransferNotified
 *
 * @author Petr Surkov <petrsurkov@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class TransferNotified {

    private final Set<String> notifiedUserIds;

    @JsonCreator
    public TransferNotified(@JsonProperty("notifiedUserIds") Set<String> notifiedUserIds) {
        this.notifiedUserIds = notifiedUserIds;
    }

    public static Builder builder() {
        return new TransferNotified.Builder();
    }

    public Set<String> getNotifiedUserIds() {
        return notifiedUserIds;
    }

    public static TransferNotified from(ResponsibleAndNotified responsibleAndNotified) {
        return TransferNotified.builder()
                .notifiedUserIds(responsibleAndNotified.getNotifiedUsers()
                        .stream()
                        .map(UserModel::getId)
                        .collect(Collectors.toSet()))
                .build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferNotified that = (TransferNotified) o;
        return notifiedUserIds.equals(that.notifiedUserIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(notifiedUserIds);
    }

    @Override
    public String toString() {
        return "TransferNotified{" +
                "notifiedUserIds=" + notifiedUserIds +
                '}';
    }

    public static class Builder {
        private Set<String> notifiedUserIds;

        public Builder notifiedUserIds(Set<String> notifiedUserIds) {
            this.notifiedUserIds = notifiedUserIds;
            return this;
        }

        public TransferNotified build() {
            return new TransferNotified(notifiedUserIds);
        }
    }
}
