package ru.yandex.intranet.d.model.transfers;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Transfer request history fields.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class TransferRequestHistoryFields {

    private final Long version;
    private final String summary;
    private final String description;
    private final String trackerIssueKey;
    private final TransferRequestType type;
    private final TransferRequestStatus status;

    @JsonCreator
    public TransferRequestHistoryFields(@JsonProperty("version") Long version,
                                        @JsonProperty("summary") String summary,
                                        @JsonProperty("description") String description,
                                        @JsonProperty("trackerIssueKey") String trackerIssueKey,
                                        @JsonProperty("type") TransferRequestType type,
                                        @JsonProperty("status") TransferRequestStatus status) {
        this.version = version;
        this.summary = summary;
        this.description = description;
        this.trackerIssueKey = trackerIssueKey;
        this.type = type;
        this.status = status;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TransferRequestHistoryFields value) {
        return new Builder(value);
    }

    public Optional<Long> getVersion() {
        return Optional.ofNullable(version);
    }

    public Optional<String> getSummary() {
        return Optional.ofNullable(summary);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Optional<String> getTrackerIssueKey() {
        return Optional.ofNullable(trackerIssueKey);
    }

    public Optional<TransferRequestType> getType() {
        return Optional.ofNullable(type);
    }

    public Optional<TransferRequestStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferRequestHistoryFields that = (TransferRequestHistoryFields) o;
        return Objects.equals(version, that.version) &&
                Objects.equals(summary, that.summary) &&
                Objects.equals(description, that.description) &&
                Objects.equals(trackerIssueKey, that.trackerIssueKey) &&
                type == that.type &&
                status == that.status;
    }

    @Override
    public int hashCode() {
        return Objects.hash(version, summary, description, trackerIssueKey, type, status);
    }

    @Override
    public String toString() {
        return "TransferRequestHistoryFields{" +
                "version=" + version +
                ", summary='" + summary + '\'' +
                ", description='" + description + '\'' +
                ", trackerIssueKey='" + trackerIssueKey + '\'' +
                ", type=" + type +
                ", status=" + status +
                '}';
    }

    public static final class Builder {

        private Long version;
        private String summary;
        private String description;
        private String trackerIssueKey;
        private TransferRequestType type;
        private TransferRequestStatus status;

        private Builder() {
        }

        private Builder(TransferRequestHistoryFields value) {
            this.version = value.version;
            this.summary = value.summary;
            this.description = value.description;
            this.trackerIssueKey = value.trackerIssueKey;
            this.type = value.type;
            this.status = value.status;
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder trackerIssueKey(String trackerIssueKey) {
            this.trackerIssueKey = trackerIssueKey;
            return this;
        }

        public Builder type(TransferRequestType type) {
            this.type = type;
            return this;
        }

        public Builder status(TransferRequestStatus status) {
            this.status = status;
            return this;
        }

        public TransferRequestHistoryFields build() {
            return new TransferRequestHistoryFields(version, summary, description, trackerIssueKey, type, status);
        }

    }

}
