package ru.yandex.intranet.d.model.transfers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Transfer votes.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TransferVotes {

    private final Set<TransferVote> votes;

    @JsonCreator
    public TransferVotes(@JsonProperty("votes") Set<TransferVote> votes) {
        this.votes = votes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TransferVotes value) {
        return new Builder(value);
    }

    public Set<TransferVote> getVotes() {
        return votes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TransferVotes that = (TransferVotes) o;
        return Objects.equals(votes, that.votes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(votes);
    }

    @Override
    public String toString() {
        return "TransferVotes{" +
                "votes=" + votes +
                '}';
    }

    public static final class Builder {

        private final Set<TransferVote> votes = new HashSet<>();

        private Builder() {
        }

        private Builder(TransferVotes value) {
            this.votes.addAll(value.votes);
        }

        public Builder addVote(TransferVote value) {
            this.votes.add(value);
            return this;
        }

        public Builder addVotes(TransferVote... values) {
            this.votes.addAll(Arrays.asList(values));
            return this;
        }

        public Builder addVotes(Collection<? extends TransferVote> values) {
            this.votes.addAll(values);
            return this;
        }

        public TransferVotes build() {
            return new TransferVotes(votes);
        }

    }

}
