package ru.yandex.intranet.d.model.uniques

import ru.yandex.intranet.d.model.TenantId
import java.time.Instant

/**
 * Request unique.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class RequestUniqueModel(val tenantId: TenantId, val unique: String, val subject: RequestUniqueSubject,
                              val endpoint: RequestUniqueEndpoint, val createdAt: Instant,
                              val metadata: RequestUniqueMetadata) {
    fun identity(): RequestUniqueIdentity {
        return RequestUniqueIdentity(tenantId, unique, subject, endpoint)
    }
}
