package ru.yandex.intranet.d.model.uniques

import ru.yandex.intranet.d.util.Uuids

/**
 * Request unique subject.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
data class RequestUniqueSubject(val userId: String?, val tvmId: String?) {
    companion object {
        fun empty(): RequestUniqueSubject {
            return RequestUniqueSubject(null, null)
        }
        fun user(userId: String): RequestUniqueSubject {
            return RequestUniqueSubject(userId, null)
        }
        fun tvmId(tvmId: String): RequestUniqueSubject {
            return RequestUniqueSubject(null, tvmId)
        }
        fun deserialize(value: String): RequestUniqueSubject {
            val values = value.split('_')
            val userId = if (values.isNotEmpty() && values[0].isNotBlank() && Uuids.isValidUuid(values[0])) {
                values[0]
            } else {
                null
            }
            val tvmId = if (values.size > 1 && values[1].isNotBlank()) {
                values[1]
            } else {
                null
            }
            return RequestUniqueSubject(userId, tvmId)
        }
    }
    fun serialize(): String {
        return (userId ?: "") + "_" + (tvmId ?: "")
    }
}
