package ru.yandex.intranet.d.model.units;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * DecimalWithUnit.
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 * @since 10.02.2021
 */
public final class DecimalWithUnit {
    private final BigDecimal amount;
    private final UnitModel unit;

    public DecimalWithUnit(BigDecimal amount, UnitModel unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public UnitModel getUnit() {
        return unit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DecimalWithUnit that = (DecimalWithUnit) o;
        return Objects.equals(amount, that.amount) && Objects.equals(unit, that.unit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, unit);
    }

    @Override
    public String toString() {
        return amount + " " + unit.getShortNamePluralEn();
    }
}
