package ru.yandex.intranet.d.model.units;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Grammatical case.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public enum GrammaticalCase {

    NOMINATIVE,
    GENITIVE,
    DATIVE,
    ACCUSATIVE,
    INSTRUMENTAL,
    PREPOSITIONAL,
    UNKNOWN;

    @JsonValue
    public String toJsonValue() {
        return name();
    }

    @JsonCreator
    public static GrammaticalCase fromJsonValue(String value) {
        try {
            return GrammaticalCase.valueOf(value);
        } catch (IllegalArgumentException e) {
            return GrammaticalCase.UNKNOWN;
        }
    }

}
