package ru.yandex.intranet.d.model.units;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

/**
 * Unit.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class UnitModel {

    private final String id;
    private final String key;
    private final Map<GrammaticalCase, String> shortNameSingularRu;
    private final Map<GrammaticalCase, String> shortNamePluralRu;
    private final String shortNameSingularEn;
    private final String shortNamePluralEn;
    private final Map<GrammaticalCase, String> longNameSingularRu;
    private final Map<GrammaticalCase, String> longNamePluralRu;
    private final String longNameSingularEn;
    private final String longNamePluralEn;
    private final long base;
    private final long power;
    private final boolean deleted;

    @JsonCreator
    @SuppressWarnings("ParameterNumber")
    public UnitModel(@JsonProperty("id") String id,
                     @JsonProperty("key") String key,
                     @JsonProperty("shortNameSingularRu") Map<GrammaticalCase, String> shortNameSingularRu,
                     @JsonProperty("shortNamePluralRu") Map<GrammaticalCase, String> shortNamePluralRu,
                     @JsonProperty("shortNameSingularEn") String shortNameSingularEn,
                     @JsonProperty("shortNamePluralEn") String shortNamePluralEn,
                     @JsonProperty("longNameSingularRu") Map<GrammaticalCase, String> longNameSingularRu,
                     @JsonProperty("longNamePluralRu") Map<GrammaticalCase, String> longNamePluralRu,
                     @JsonProperty("longNameSingularEn") String longNameSingularEn,
                     @JsonProperty("longNamePluralEn") String longNamePluralEn,
                     @JsonProperty("base") long base,
                     @JsonProperty("power") long power,
                     @JsonProperty("deleted") boolean deleted) {
        this.id = id;
        this.key = key;
        this.shortNameSingularRu = shortNameSingularRu;
        this.shortNamePluralRu = shortNamePluralRu;
        this.shortNameSingularEn = shortNameSingularEn;
        this.shortNamePluralEn = shortNamePluralEn;
        this.longNameSingularRu = longNameSingularRu;
        this.longNamePluralRu = longNamePluralRu;
        this.longNameSingularEn = longNameSingularEn;
        this.longNamePluralEn = longNamePluralEn;
        this.base = base;
        this.power = power;
        this.deleted = deleted;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return id;
    }

    public String getKey() {
        return key;
    }

    /**
     * На самом деле возвращает всегда в английских единицах измерения.
     *
     * Когда это будет исправлено не забыть удалить функцию ниже, а у этой
     * убрать {@link JsonIgnore}
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @JsonIgnore
    public Map<GrammaticalCase, String> getShortNameSingularRu() {
        return Arrays.stream(GrammaticalCase.values())
                .filter(grammaticalCase -> !grammaticalCase.equals(GrammaticalCase.UNKNOWN))
                .collect(Collectors.toMap(Function.identity(), x -> getShortNameSingularEn()));
//        return shortNameSingularRu;
    }


    /**
     * Эта функция нужна только для тестирования на время пока мы в качестве русских
     * единиц возвращаем английские.
     *
     * Не надо пользоваться ей.
     *
     * Надо удалить её после того как вернём русские единицы,
     * а её использование в тесте заменить на функцию выше, её
     * при этом надо исправить.
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @Deprecated
    @JsonProperty("shortNameSingularRu")
    public Map<GrammaticalCase, String> realShortNameSingularRu() {
        return shortNameSingularRu;
    }

    /**
     * На самом деле возвращает всегда в английских единицах измерения.
     *
     * Когда это будет исправлено не забыть удалить функцию ниже, а у этой
     * убрать {@link JsonIgnore}
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @JsonIgnore
    public Map<GrammaticalCase, String> getShortNamePluralRu() {
        return Arrays.stream(GrammaticalCase.values())
                .filter(grammaticalCase -> !grammaticalCase.equals(GrammaticalCase.UNKNOWN))
                .collect(Collectors.toMap(Function.identity(), x -> getShortNamePluralEn()));
//        return shortNamePluralRu;
    }

    /**
     * Эта функция нужна только для тестирования на время пока мы в качестве русских
     * единиц возвращаем английские.
     *
     * Не надо пользоваться ей.
     *
     * Надо удалить её после того как вернём русские единицы,
     * а её использование в тесте заменить на функцию выше, её
     * при этом надо исправить.
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @Deprecated
    @JsonProperty("shortNamePluralRu")
    public Map<GrammaticalCase, String> realShortNamePluralRu() {
        return shortNamePluralRu;
    }

    public String getShortNameSingularEn() {
        return shortNameSingularEn;
    }

    public String getShortNamePluralEn() {
        return shortNamePluralEn;
    }

    /**
     * На самом деле возвращает всегда в английских единицах измерения.
     *
     * Когда это будет исправлено не забыть удалить функцию ниже, а у этой
     * убрать {@link JsonIgnore}
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @JsonIgnore
    public Map<GrammaticalCase, String> getLongNameSingularRu() {
        return Arrays.stream(GrammaticalCase.values())
                .filter(grammaticalCase -> !grammaticalCase.equals(GrammaticalCase.UNKNOWN))
                .collect(Collectors.toMap(Function.identity(), x -> getLongNameSingularEn()));
//        return longNameSingularRu;
    }

    /**
     * Эта функция нужна только для тестирования на время пока мы в качестве русских
     * единиц возвращаем английские.
     *
     * Не надо пользоваться ей.
     *
     * Надо удалить её после того как вернём русские единицы,
     * а её использование в тесте заменить на функцию выше, её
     * при этом надо исправить.
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @Deprecated
    @JsonProperty("longNameSingularRu")
    public Map<GrammaticalCase, String> realLongNameSingularRu() {
        return longNameSingularRu;
    }

    /**
     * На самом деле возвращает всегда в английских единицах измерения.
     *
     * Когда это будет исправлено не забыть удалить функцию ниже, а у этой
     * убрать {@link JsonIgnore}
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @JsonIgnore
    public Map<GrammaticalCase, String> getLongNamePluralRu() {
        return Arrays.stream(GrammaticalCase.values())
                .filter(grammaticalCase -> !grammaticalCase.equals(GrammaticalCase.UNKNOWN))
                .collect(Collectors.toMap(Function.identity(), x -> getLongNamePluralEn()));
//        return longNamePluralRu;
    }

    /**
     * Эта функция нужна только для тестирования на время пока мы в качестве русских
     * единиц возвращаем английские.
     *
     * Не надо пользоваться ей.
     *
     * Надо удалить её после того как вернём русские единицы,
     * а её использование в тесте заменить на функцию выше, её
     * при этом надо исправить.
     *
     * Не забыть разобраться со всеми аналогичными функциями в этом классе.
     */
    @Deprecated
    @JsonProperty("longNamePluralRu")
    public Map<GrammaticalCase, String> realLongNamePluralRu() {
        return longNamePluralRu;
    }

    public String getLongNameSingularEn() {
        return longNameSingularEn;
    }

    public String getLongNamePluralEn() {
        return longNamePluralEn;
    }

    public long getBase() {
        return base;
    }

    public long getPower() {
        return power;
    }

    public boolean isDeleted() {
        return deleted;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnitModel unitModel = (UnitModel) o;
        return base == unitModel.base &&
                power == unitModel.power &&
                deleted == unitModel.deleted &&
                Objects.equals(id, unitModel.id) &&
                Objects.equals(key, unitModel.key) &&
                Objects.equals(shortNameSingularRu, unitModel.shortNameSingularRu) &&
                Objects.equals(shortNamePluralRu, unitModel.shortNamePluralRu) &&
                Objects.equals(shortNameSingularEn, unitModel.shortNameSingularEn) &&
                Objects.equals(shortNamePluralEn, unitModel.shortNamePluralEn) &&
                Objects.equals(longNameSingularRu, unitModel.longNameSingularRu) &&
                Objects.equals(longNamePluralRu, unitModel.longNamePluralRu) &&
                Objects.equals(longNameSingularEn, unitModel.longNameSingularEn) &&
                Objects.equals(longNamePluralEn, unitModel.longNamePluralEn);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, key, shortNameSingularRu, shortNamePluralRu, shortNameSingularEn,
                shortNamePluralEn, longNameSingularRu, longNamePluralRu, longNameSingularEn,
                longNamePluralEn, base, power, deleted);
    }

    @Override
    public String toString() {
        return "UnitModel{" +
                "id='" + id + '\'' +
                ", key='" + key + '\'' +
                ", shortNameSingularRu=" + shortNameSingularRu +
                ", shortNamePluralRu=" + shortNamePluralRu +
                ", shortNameSingularEn='" + shortNameSingularEn + '\'' +
                ", shortNamePluralEn='" + shortNamePluralEn + '\'' +
                ", longNameSingularRu=" + longNameSingularRu +
                ", longNamePluralRu=" + longNamePluralRu +
                ", longNameSingularEn='" + longNameSingularEn + '\'' +
                ", longNamePluralEn='" + longNamePluralEn + '\'' +
                ", base=" + base +
                ", power=" + power +
                ", deleted=" + deleted +
                '}';
    }

    public static final class Builder {

        private final Map<GrammaticalCase, String> shortNameSingularRu = new HashMap<>();
        private final Map<GrammaticalCase, String> shortNamePluralRu = new HashMap<>();
        private final Map<GrammaticalCase, String> longNameSingularRu = new HashMap<>();
        private final Map<GrammaticalCase, String> longNamePluralRu = new HashMap<>();

        private String id;
        private String key;
        private String shortNameSingularEn;
        private String shortNamePluralEn;
        private String longNameSingularEn;
        private String longNamePluralEn;
        private Long base;
        private Long power;
        private Boolean deleted;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder shortNameSingularEn(String shortNameSingularEn) {
            this.shortNameSingularEn = shortNameSingularEn;
            return this;
        }

        public Builder shortNamePluralEn(String shortNamePluralEn) {
            this.shortNamePluralEn = shortNamePluralEn;
            return this;
        }

        public Builder longNameSingularEn(String longNameSingularEn) {
            this.longNameSingularEn = longNameSingularEn;
            return this;
        }

        public Builder longNamePluralEn(String longNamePluralEn) {
            this.longNamePluralEn = longNamePluralEn;
            return this;
        }

        public Builder base(long base) {
            this.base = base;
            return this;
        }

        public Builder power(long power) {
            this.power = power;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder putShortNameSingularRu(GrammaticalCase grammaticalCase, String value) {
            this.shortNameSingularRu.put(grammaticalCase, value);
            return this;
        }

        public Builder putShortNamePluralRu(GrammaticalCase grammaticalCase, String value) {
            this.shortNamePluralRu.put(grammaticalCase, value);
            return this;
        }

        public Builder putLongNameSingularRu(GrammaticalCase grammaticalCase, String value) {
            this.longNameSingularRu.put(grammaticalCase, value);
            return this;
        }

        public Builder putLongNamePluralRu(GrammaticalCase grammaticalCase, String value) {
            this.longNamePluralRu.put(grammaticalCase, value);
            return this;
        }

        public boolean hasChanges(UnitModel unit) {
            if (!Objects.equals(id, unit.getId())) {
                return true;
            }
            if (!Objects.equals(key, unit.getKey())) {
                return true;
            }
            if (!Objects.equals(shortNameSingularRu, unit.getShortNameSingularRu())) {
                return true;
            }
            if (!Objects.equals(shortNamePluralRu, unit.getShortNamePluralRu())) {
                return true;
            }
            if (!Objects.equals(shortNameSingularEn, unit.getShortNameSingularEn())) {
                return true;
            }
            if (!Objects.equals(shortNamePluralEn, unit.getShortNamePluralEn())) {
                return true;
            }
            if (!Objects.equals(longNameSingularRu, unit.getLongNameSingularRu())) {
                return true;
            }
            if (!Objects.equals(longNamePluralRu, unit.getLongNamePluralRu())) {
                return true;
            }
            if (!Objects.equals(longNameSingularEn, unit.getLongNameSingularEn())) {
                return true;
            }
            if (!Objects.equals(longNamePluralEn, unit.getLongNamePluralEn())) {
                return true;
            }
            if (!Objects.equals(base, unit.getBase())) {
                return true;
            }
            if (!Objects.equals(power, unit.getPower())) {
                return true;
            }
            if (!Objects.equals(deleted, unit.isDeleted())) {
                return true;
            }
            return false;
        }

        public UnitModel build() {
            Preconditions.checkNotNull(id, "Id is required");
            Preconditions.checkNotNull(key, "Key is required");
            Preconditions.checkNotNull(shortNameSingularEn, "ShortNameSingularEn is required");
            Preconditions.checkNotNull(shortNamePluralEn, "ShortNamePluralEn is required");
            Preconditions.checkNotNull(longNameSingularEn, "LongNameSingularEn is required");
            Preconditions.checkNotNull(longNamePluralEn, "LongNamePluralEn is required");
            Preconditions.checkNotNull(base, "Base is required");
            Preconditions.checkNotNull(power, "Power is required");
            Preconditions.checkNotNull(deleted, "Deleted is required");
            return new UnitModel(id, key, shortNameSingularRu, shortNamePluralRu, shortNameSingularEn,
                    shortNamePluralEn, longNameSingularRu, longNamePluralRu, longNameSingularEn,
                    longNamePluralEn, base, power, deleted);
        }

    }

}
