package ru.yandex.intranet.d.model.usage

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import java.math.BigInteger

/**
 * Histogram bin.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
data class HistogramBin(
    // inclusive
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val from: BigInteger,
    // exclusive, except the last bin
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val to: BigInteger,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val amount: Long
)
