package ru.yandex.intranet.d.model.usage

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude

/**
 * Service usage amounts.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class ServiceUsageAmounts @JsonCreator constructor(
    // Non-null when at least one field is non-zero
    val own: UsageAmount?,
    // Non-null when at least one field is non-zero
    val subtree: UsageAmount?,
    // Non-null when at least one field is non-zero and subtree is non-null
    val total: UsageAmount?
)
