package ru.yandex.intranet.d.model.usage

import com.fasterxml.jackson.annotation.JsonCreator
import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.math.BigInteger

/**
 * Usage amount.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class UsageAmount @JsonCreator constructor(
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val value: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val average: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val min: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val max: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val median: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val variance: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val accumulated: BigInteger?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val accumulatedDuration: Long?,
    val histogram: List<HistogramBin>?,
    @Deprecated("Deprecated, delete later, use valuesX and valuesY instead")
    val values: List<UsagePoint>?,
    val valuesX: List<Long>?,
    val valuesY: List<BigInteger>?,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val unused: BigInteger?
)
