package ru.yandex.intranet.d.model.usage

import com.fasterxml.jackson.annotation.JsonFormat
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import com.fasterxml.jackson.annotation.JsonInclude
import java.math.BigInteger

/**
 * Usage amount.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
data class UsagePoint(
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val x: Long,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val y: BigInteger,
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    val dx: Long?
)
