package ru.yandex.intranet.d.model.users;

import java.util.Objects;

/**
 * AbcServiceMemberModel
 * @author Ruslan Kadriev <aqru@yandex-team.ru>
 * @since 18-11-2020
 */
public final class AbcServiceMemberModel {
    private final long id;
    private final long staffId;
    private final long serviceId;
    private final long roleId;
    private final AbcServiceMemberState state;

    private AbcServiceMemberModel(Builder builder) {
        this.id = builder.id;
        this.staffId = builder.staffId;
        this.serviceId = builder.serviceId;
        this.roleId = builder.roleId;
        this.state = builder.state;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getId() {
        return id;
    }

    public long getStaffId() {
        return staffId;
    }

    public long getServiceId() {
        return serviceId;
    }

    public long getRoleId() {
        return roleId;
    }

    public AbcServiceMemberState getState() {
        return state;
    }

    public static class Builder {
        private long id;
        private long staffId;
        private long serviceId;
        private long roleId;
        private AbcServiceMemberState state;

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder staffId(long staffId) {
            this.staffId = staffId;
            return this;
        }

        public Builder serviceId(long serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder roleId(long roleId) {
            this.roleId = roleId;
            return this;
        }

        public Builder state(AbcServiceMemberState state) {
            this.state = state;
            return this;
        }

        public AbcServiceMemberModel build() {
            return new AbcServiceMemberModel(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AbcServiceMemberModel that = (AbcServiceMemberModel) o;
        return id == that.id &&
            staffId == that.staffId &&
            serviceId == that.serviceId &&
            roleId == that.roleId &&
            state.equals(that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, staffId, serviceId, roleId, state);
    }

    @Override
    public String toString() {
        return "AbcServiceMemberModel{" +
                "id=" + id +
                ", staffId=" + staffId +
                ", serviceId=" + serviceId +
                ", roleId=" + roleId +
                ", state='" + state + "'" +
                "}";
    }
}
