package ru.yandex.intranet.d.model.users;

import java.util.HashMap;
import java.util.Map;

public enum AbcServiceMemberState {
    UNKNOWN(null),
    ACTIVE("active"),
    DEPRIVING("depriving"),
    DEPRIVED("deprived"),
    REQUESTED("requested");

    private final String key;

    AbcServiceMemberState(String key) {
        this.key = key;
        Mapper.BY_KEY.put(key, this);
    }

    @Override
    public String toString() {
        return key;
    }

    public static AbcServiceMemberState fromString(String value) {
        return Mapper.BY_KEY.getOrDefault(value, UNKNOWN);
    }

    private static final class Mapper {
        private static final Map<String, AbcServiceMemberState> BY_KEY = new HashMap<>();
    }
}
