package ru.yandex.intranet.d.model.users;

/**
 * AbcStaffAffiliation.
 * <p>
 * SELECT DISTINCT affiliation FROM `abc_sync/public_intranet_staff`;
 * https://yql.yandex-team.ru/Operations/X09fWVPzVCmuBpHqd3MEjeFVqF0tN8uQIVcZ2Q4-P6c=
 *
 * @author Vladimir Zaytsev <vzay@yandex-team.ru>
 */
public enum AbcStaffAffiliation {
    EXTERNAL(StaffAffiliation.EXTERNAL),
    YAMONEY(StaffAffiliation.YA_MONEY),
    YANDEX(StaffAffiliation.YANDEX);

    private final StaffAffiliation affiliation;

    AbcStaffAffiliation(StaffAffiliation affiliation) {
        this.affiliation = affiliation;
    }

    public StaffAffiliation toStaffAffiliation() {
        return affiliation;
    }
}
