package ru.yandex.intranet.d.model.users;

import java.util.Objects;

@SuppressWarnings("unused")
public class AbcUserModel {
    private final long id; // bigint NOT NULL
    private final String firstName; // character varying(50) DEFAULT ''::character varying NOT NULL,
    private final String lastName; // character varying(100) DEFAULT ''::character varying NOT NULL,
    private final String login; // character varying(50) DEFAULT ''::character varying NOT NULL,
    private final boolean isDismissed; // boolean DEFAULT false NOT NULL,
    private final char gender; // character varying(1) DEFAULT ''::character varying NOT NULL,
    private final String workEmail; // character varying(100) DEFAULT ''::character varying NOT NULL,
    private final String firstNameEn; // character varying(50) DEFAULT ''::character varying NOT NULL,
    private final String lastNameEn; // character varying(100) DEFAULT ''::character varying NOT NULL,
    private final String langUi; // character varying(2) DEFAULT ''::character varying NOT NULL,
    private final String tz; // character varying(30) DEFAULT ''::character varying,
    private final String uid; // character varying(16),
    private final Boolean isRobot; // boolean DEFAULT false NOT NULL,
    private final String affiliation; // character varying(32) DEFAULT 'external'::character varying NOT NULL,

    protected AbcUserModel(Builder builder) {
        this.id = builder.id;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.login = builder.login;
        this.isDismissed = builder.isDismissed;
        this.gender = builder.gender;
        this.workEmail = builder.workEmail;
        this.firstNameEn = builder.firstNameEn;
        this.lastNameEn = builder.lastNameEn;
        this.langUi = builder.langUi;
        this.tz = builder.tz;
        this.uid = builder.uid;
        this.isRobot = builder.isRobot;
        this.affiliation = builder.affiliation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public long getId() {
        return id;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public String getLogin() {
        return login;
    }

    public boolean isDismissed() {
        return isDismissed;
    }

    public char getGender() {
        return gender;
    }

    public String getWorkEmail() {
        return workEmail;
    }

    public String getFirstNameEn() {
        return firstNameEn;
    }

    public String getLastNameEn() {
        return lastNameEn;
    }

    public String getLangUi() {
        return langUi;
    }

    public String getTz() {
        return tz;
    }

    public String getUid() {
        return uid;
    }

    public Boolean getRobot() {
        return isRobot;
    }

    public String getAffiliation() {
        return affiliation;
    }

    public Builder getCopyBuilder() {
        return newBuilder()
                .setId(id)
                .setFirstName(firstName)
                .setLastName(lastName)
                .setLogin(login)
                .setIsDismissed(isDismissed)
                .setGender(gender)
                .setWorkEmail(workEmail)
                .setFirstNameEn(firstNameEn)
                .setLastNameEn(lastNameEn)
                .setLangUi(langUi)
                .setTz(tz)
                .setUid(uid)
                .setIsRobot(isRobot)
                .setAffiliation(affiliation);
    }

    public static class Builder {
        private long id; // bigint NOT NULL
        private String firstName; // character varying(50) DEFAULT ''::character varying NOT NULL,
        private String lastName; // character varying(100) DEFAULT ''::character varying NOT NULL,
        private String login; // character varying(50) DEFAULT ''::character varying NOT NULL,
        private boolean isDismissed; // boolean DEFAULT false NOT NULL,
        private char gender; // character varying(1) DEFAULT ''::character varying NOT NULL,
        private String workEmail; // character varying(100) DEFAULT ''::character varying NOT NULL,
        private String firstNameEn; // character varying(50) DEFAULT ''::character varying NOT NULL,
        private String lastNameEn; // character varying(100) DEFAULT ''::character varying NOT NULL,
        private String langUi; // character varying(2) DEFAULT ''::character varying NOT NULL,
        private String tz; // character varying(30) DEFAULT ''::character varying,
        private String uid; // character varying(16),
        private Boolean isRobot; // boolean DEFAULT false NOT NULL,
        private String affiliation; // character varying(32) DEFAULT 'external'::character varying NOT NULL,

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder setLogin(String login) {
            this.login = login;
            return this;
        }

        public Builder setIsDismissed(boolean isDismissed) {
            this.isDismissed = isDismissed;
            return this;
        }

        public Builder setGender(char gender) {
            this.gender = gender;
            return this;
        }

        public Builder setWorkEmail(String workEmail) {
            this.workEmail = workEmail;
            return this;
        }

        public Builder setFirstNameEn(String firstNameEn) {
            this.firstNameEn = firstNameEn;
            return this;
        }

        public Builder setLastNameEn(String lastNameEn) {
            this.lastNameEn = lastNameEn;
            return this;
        }

        public Builder setLangUi(String langUi) {
            this.langUi = langUi;
            return this;
        }

        public Builder setTz(String tz) {
            this.tz = tz;
            return this;
        }

        public Builder setUid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder setIsRobot(Boolean isRobot) {
            this.isRobot = isRobot;
            return this;
        }

        public Builder setAffiliation(String affiliation) {
            this.affiliation = affiliation;
            return this;
        }

        public AbcUserModel build() {
            return new AbcUserModel(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AbcUserModel that = (AbcUserModel) o;
        return id == that.id &&
                isDismissed == that.isDismissed &&
                gender == that.gender &&
                Objects.equals(firstName, that.firstName) &&
                Objects.equals(lastName, that.lastName) &&
                Objects.equals(login, that.login) &&
                Objects.equals(workEmail, that.workEmail) &&
                Objects.equals(firstNameEn, that.firstNameEn) &&
                Objects.equals(lastNameEn, that.lastNameEn) &&
                Objects.equals(langUi, that.langUi) &&
                Objects.equals(tz, that.tz) &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(isRobot, that.isRobot) &&
                Objects.equals(affiliation, that.affiliation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, firstName, lastName, login, isDismissed, gender, workEmail, firstNameEn, lastNameEn,
                langUi, tz, uid, isRobot, affiliation);
    }

    @Override
    public String toString() {
        return "AbcUserModel{" +
                "id=" + id +
                ", firstName='" + firstName + '\'' +
                ", lastName='" + lastName + '\'' +
                ", login='" + login + '\'' +
                ", isDismissed=" + isDismissed +
                ", gender=" + gender +
                ", workEmail='" + workEmail + '\'' +
                ", firstNameEn='" + firstNameEn + '\'' +
                ", lastNameEn='" + lastNameEn + '\'' +
                ", langUi='" + langUi + '\'' +
                ", tz='" + tz + '\'' +
                ", uid='" + uid + '\'' +
                ", isRobot=" + isRobot +
                ", affiliation='" + affiliation + '\'' +
                '}';
    }
}
