package ru.yandex.intranet.d.model.users;

import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ExtendedAbcUserModel extends AbcUserModel {
    private final Map<UserServiceRoles, Set<Long>> roles;

    public ExtendedAbcUserModel(Builder builder) {
        super(builder.abcUserModel.getCopyBuilder());
        this.roles = Map.copyOf(builder.roles);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<UserServiceRoles, Set<Long>> getRoles() {
        return roles;
    }

    public static class Builder {
        private Map<UserServiceRoles, Set<Long>> roles;
        private AbcUserModel abcUserModel;

        public Builder roles(Map<UserServiceRoles, Set<Long>> roles) {
            this.roles = roles;
            return this;
        }

        public Builder abcUserModel(AbcUserModel abcUserModel) {
            this.abcUserModel = abcUserModel;
            return this;
        }

        public ExtendedAbcUserModel build() {
            return new ExtendedAbcUserModel(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExtendedAbcUserModel that = (ExtendedAbcUserModel) o;
        return Objects.equals(roles, that.roles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), roles);
    }

    @Override
    public String toString() {
        return "ExtendedAbcUserModel{" +
                "roles=" + roles +
                "} " + super.toString();
    }
}
