package ru.yandex.intranet.d.schedulers.local;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

/**
 * Local schedulers thread pool configuration.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Configuration
public class LocalSchedulersPoolConfiguration {

    @Bean("localThreadPoolTaskScheduler")
    public ThreadPoolTaskScheduler localThreadPoolTaskScheduler(
            @Value("${scheduler.local.shutdownTimeoutMs}") long shutdownTimeoutMs) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(10);
        scheduler.setDaemon(true);
        scheduler.setThreadNamePrefix("local-scheduler-executor-");
        scheduler.setAwaitTerminationMillis(shutdownTimeoutMs);
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        return scheduler;
    }

}
