package ru.yandex.intranet.d.services.accounts.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Account by folder and provider continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountByFolderAndProviderContinuationToken {

    private final String accountsSpaceId;
    private final String accountId;

    @JsonCreator
    public AccountByFolderAndProviderContinuationToken(String accountsSpaceId, String accountId) {
        this.accountsSpaceId = accountsSpaceId;
        this.accountId = accountId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountByFolderAndProviderContinuationToken that = (AccountByFolderAndProviderContinuationToken) o;
        return Objects.equals(accountsSpaceId, that.accountsSpaceId) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountsSpaceId, accountId);
    }

    @Override
    public String toString() {
        return "AccountByFolderAndProviderContinuationToken{" +
                "accountsSpaceId='" + accountsSpaceId + '\'' +
                ", accountId='" + accountId + '\'' +
                '}';
    }

}
