package ru.yandex.intranet.d.services.accounts.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Account by folder continuation token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class AccountByFolderContinuationToken {

    private final String providerId;
    private final String accountsSpaceId;
    private final String accountId;

    @JsonCreator
    public AccountByFolderContinuationToken(String providerId, String accountsSpaceId, String accountId) {
        this.providerId = providerId;
        this.accountsSpaceId = accountsSpaceId;
        this.accountId = accountId;
    }

    public String getProviderId() {
        return providerId;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getAccountsSpaceId() {
        return Optional.ofNullable(accountsSpaceId);
    }

    public String getAccountId() {
        return accountId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountByFolderContinuationToken that = (AccountByFolderContinuationToken) o;
        return Objects.equals(providerId, that.providerId) &&
                Objects.equals(accountsSpaceId, that.accountsSpaceId) &&
                Objects.equals(accountId, that.accountId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(providerId, accountsSpaceId, accountId);
    }

    @Override
    public String toString() {
        return "AccountByFolderContinuationToken{" +
                "providerId='" + providerId + '\'' +
                ", accountsSpaceId='" + accountsSpaceId + '\'' +
                ", accountId='" + accountId + '\'' +
                '}';
    }

}
