package ru.yandex.intranet.d.services.accounts.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * Account operation failure metadata.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Schema(description = "Account operation failure metadata.")
public final class AccountOperationFailureMeta {

    private final String operationId;

    @JsonCreator
    public AccountOperationFailureMeta(String operationId) {
        this.operationId = operationId;
    }

    @Schema(description = "Unique operation id.", required = true)
    public String getOperationId() {
        return operationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountOperationFailureMeta that = (AccountOperationFailureMeta) o;
        return Objects.equals(operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationId);
    }

    @Override
    public String toString() {
        return "AccountOperationFailureMeta{" +
                "operationId='" + operationId + '\'' +
                '}';
    }

}
