package ru.yandex.intranet.d.services.accounts.model;

import java.util.Objects;
import java.util.Optional;

import ru.yandex.intranet.d.model.accounts.AccountModel;

/**
 * Account operation result.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class AccountOperationResult {

    private final AccountOperationResultStatus operationStatus;
    private final AccountModel account;
    private final String operationId;

    private AccountOperationResult(AccountOperationResultStatus operationStatus, AccountModel account,
                                   String operationId) {
        this.operationStatus = operationStatus;
        this.account = account;
        this.operationId = operationId;
    }

    public static AccountOperationResult success(AccountModel account, String operationId) {
        return new AccountOperationResult(AccountOperationResultStatus.SUCCESS, account, operationId);
    }

    public static AccountOperationResult inProgress(String operationId) {
        return new AccountOperationResult(AccountOperationResultStatus.IN_PROGRESS, null, operationId);
    }

    public AccountOperationResultStatus getOperationStatus() {
        return operationStatus;
    }

    public Optional<AccountModel> getAccount() {
        return Optional.ofNullable(account);
    }

    public String getOperationId() {
        return operationId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountOperationResult that = (AccountOperationResult) o;
        return operationStatus == that.operationStatus &&
                Objects.equals(account, that.account) &&
                Objects.equals(operationId, that.operationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operationStatus, account, operationId);
    }

    @Override
    public String toString() {
        return "AccountOperation{" +
                "operationStatus=" + operationStatus +
                ", account=" + account +
                ", operationId='" + operationId + '\'' +
                '}';
    }

}
