package ru.yandex.intranet.d.services.accounts.model;

import ru.yandex.intranet.d.web.model.accounts.AccountOperationStatusDto;

/**
 * Account operation status.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public enum AccountOperationResultStatus {

    IN_PROGRESS,
    SUCCESS;

    public static AccountOperationStatusDto toDto(AccountOperationResultStatus status) {
        return switch (status) {
            case SUCCESS -> AccountOperationStatusDto.SUCCESS;
            case IN_PROGRESS -> AccountOperationStatusDto.IN_PROGRESS;
        };
    }

}
