package ru.yandex.intranet.d.services.accounts.model;

import java.util.List;
import java.util.Objects;

import ru.yandex.intranet.d.model.accounts.AccountModel;
import ru.yandex.intranet.d.model.accounts.AccountSpaceModel;
import ru.yandex.intranet.d.model.accounts.AccountsQuotasModel;
import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.resources.segmentations.ResourceSegmentationModel;
import ru.yandex.intranet.d.model.resources.segments.ResourceSegmentModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;

public class AccountsByFolderResult {
    public static final AccountsByFolderResult EMPTY = new AccountsByFolderResult(List.of(), List.of(), List.of(),
            List.of(), List.of(), List.of(), List.of());

    private final List<AccountModel> accountModels;
    private final List<AccountSpaceModel> accountSpaceModels;
    private final List<AccountsQuotasModel> accountsQuotasModels;
    private final List<ResourceSegmentationModel> segmentations;
    private final List<ResourceSegmentModel> segments;
    private final List<ResourceModel> resources;
    private final List<UnitsEnsembleModel> unitEnsembles;


    public AccountsByFolderResult(List<AccountModel> accountModels, List<AccountSpaceModel> accountSpaceModels,
                                  List<AccountsQuotasModel> accountsQuotasModels,
                                  List<ResourceSegmentationModel> segmentations, List<ResourceSegmentModel> segments,
                                  List<ResourceModel> resources, List<UnitsEnsembleModel> unitEnsembles) {
        this.accountModels = accountModels;
        this.accountSpaceModels = accountSpaceModels;
        this.accountsQuotasModels = accountsQuotasModels;
        this.segmentations = segmentations;
        this.segments = segments;
        this.resources = resources;
        this.unitEnsembles = unitEnsembles;
    }

    public List<AccountModel> getAccountModels() {
        return accountModels;
    }

    public List<AccountSpaceModel> getAccountSpaceModels() {
        return accountSpaceModels;
    }

    public List<AccountsQuotasModel> getAccountsQuotasModels() {
        return accountsQuotasModels;
    }

    public List<ResourceSegmentationModel> getSegmentations() {
        return segmentations;
    }

    public List<ResourceSegmentModel> getSegments() {
        return segments;
    }

    public List<ResourceModel> getResources() {
        return resources;
    }

    public List<UnitsEnsembleModel> getUnitEnsembles() {
        return unitEnsembles;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccountsByFolderResult that = (AccountsByFolderResult) o;
        return Objects.equals(accountModels, that.accountModels) && Objects.equals(accountSpaceModels,
                that.accountSpaceModels) && Objects.equals(accountsQuotasModels, that.accountsQuotasModels)
                && Objects.equals(segmentations, that.segmentations) && Objects.equals(segments, that.segments)
                && Objects.equals(resources, that.resources) && Objects.equals(unitEnsembles, that.unitEnsembles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountModels, accountSpaceModels, accountsQuotasModels, segmentations, segments, resources,
                unitEnsembles);
    }

    @Override
    public String toString() {
        return "AccountsByFolderResult{" +
                "accountModels=" + accountModels +
                ", accountSpaceModels=" + accountSpaceModels +
                ", accountsQuotasModels=" + accountsQuotasModels +
                ", segmentations=" + segmentations +
                ", segments=" + segments +
                ", resources=" + resources +
                ", unitEnsembles=" + unitEnsembles +
                '}';
    }
}
