package ru.yandex.intranet.d.services.delivery.model;

import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Deliverable delta.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DeliverableDelta {

    private final long amount;
    private final String unitKey;

    public DeliverableDelta(long amount, String unitKey) {
        this.amount = amount;
        this.unitKey = unitKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getAmount() {
        return amount;
    }

    public String getUnitKey() {
        return unitKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliverableDelta that = (DeliverableDelta) o;
        return amount == that.amount &&
                Objects.equals(unitKey, that.unitKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(amount, unitKey);
    }

    @Override
    public String toString() {
        return "DeliverableDelta{" +
                "amount=" + amount +
                ", unitKey='" + unitKey + '\'' +
                '}';
    }

    public static final class Builder {

        private Long amount;
        private String unitKey;

        private Builder() {
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder unitKey(String unitKey) {
            this.unitKey = unitKey;
            return this;
        }

        public DeliverableDelta build() {
            Preconditions.checkNotNull(amount, "Amount is required");
            Preconditions.checkNotNull(unitKey, "UnitKey is required");
            return new DeliverableDelta(amount, unitKey);
        }

    }

}
