package ru.yandex.intranet.d.services.delivery.model;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.folders.FolderModel;
import ru.yandex.intranet.d.model.providers.ProviderModel;
import ru.yandex.intranet.d.model.resources.ResourceModel;
import ru.yandex.intranet.d.model.services.ServiceWithStatesModel;
import ru.yandex.intranet.d.model.units.UnitsEnsembleModel;
import ru.yandex.intranet.d.model.users.UserModel;

/**
 * Delivery dictionary.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DeliveryDictionary {

    private final Map<String, ResourceModel> resources;
    private final Map<String, UnitsEnsembleModel> unitsEnsembles;
    private final Map<String, FolderModel> folders;
    private final Map<Long, ServiceWithStatesModel> services;
    private final Map<Long, FolderModel> defaultFolders;
    private final Map<String, UserModel> usersByUid;
    private final Map<String, ProviderModel> providers;

    public DeliveryDictionary(Map<String, ResourceModel> resources, Map<String, UnitsEnsembleModel> unitsEnsembles,
                              Map<String, FolderModel> folders, Map<Long, ServiceWithStatesModel> services,
                              Map<Long, FolderModel> defaultFolders, Map<String, UserModel> usersByUid,
                              Map<String, ProviderModel> providers) {
        this.resources = resources;
        this.unitsEnsembles = unitsEnsembles;
        this.folders = folders;
        this.services = services;
        this.defaultFolders = defaultFolders;
        this.usersByUid = usersByUid;
        this.providers = providers;
    }

    public Map<String, ResourceModel> getResources() {
        return resources;
    }

    public Map<String, UnitsEnsembleModel> getUnitsEnsembles() {
        return unitsEnsembles;
    }

    public Map<String, FolderModel> getFolders() {
        return folders;
    }

    public Map<Long, ServiceWithStatesModel> getServices() {
        return services;
    }

    public Map<Long, FolderModel> getDefaultFolders() {
        return defaultFolders;
    }

    public Map<String, UserModel> getUsersByUid() {
        return usersByUid;
    }

    public Map<String, ProviderModel> getProviders() {
        return providers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryDictionary that = (DeliveryDictionary) o;
        return Objects.equals(resources, that.resources) &&
                Objects.equals(unitsEnsembles, that.unitsEnsembles) &&
                Objects.equals(folders, that.folders) &&
                Objects.equals(services, that.services) &&
                Objects.equals(defaultFolders, that.defaultFolders) &&
                Objects.equals(usersByUid, that.usersByUid) &&
                Objects.equals(providers, that.providers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resources, unitsEnsembles, folders, services, defaultFolders, usersByUid, providers);
    }

    @Override
    public String toString() {
        return "DeliveryDictionary{" +
                "resources=" + resources +
                ", unitsEnsembles=" + unitsEnsembles +
                ", folders=" + folders +
                ", services=" + services +
                ", defaultFolders=" + defaultFolders +
                ", usersByUid=" + usersByUid +
                ", providers=" + providers +
                '}';
    }

}
