package ru.yandex.intranet.d.services.delivery.model;

import java.util.Map;
import java.util.Objects;

import ru.yandex.intranet.d.model.quotas.QuotaModel;

/**
 * Delivery quotas.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DeliveryQuotas {

    private final Map<QuotaModel.Key, QuotaModel> quotas;

    public DeliveryQuotas(Map<QuotaModel.Key, QuotaModel> quotas) {
        this.quotas = quotas;
    }

    public Map<QuotaModel.Key, QuotaModel> getQuotas() {
        return quotas;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryQuotas that = (DeliveryQuotas) o;
        return Objects.equals(quotas, that.quotas);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quotas);
    }

    @Override
    public String toString() {
        return "DeliveryQuotas{" +
                "quotas=" + quotas +
                '}';
    }

}
