package ru.yandex.intranet.d.services.delivery.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.google.common.base.Preconditions;

/**
 * Delivery request.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class DeliveryRequest {

    private final String deliveryId;
    private final String authorUid;
    private final List<DeliverableRequest> deliverables;

    public DeliveryRequest(String deliveryId, String authorUid, List<DeliverableRequest> deliverables) {
        this.deliveryId = deliveryId;
        this.authorUid = authorUid;
        this.deliverables = deliverables;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDeliveryId() {
        return deliveryId;
    }

    public String getAuthorUid() {
        return authorUid;
    }

    public List<DeliverableRequest> getDeliverables() {
        return deliverables;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeliveryRequest that = (DeliveryRequest) o;
        return Objects.equals(deliveryId, that.deliveryId) &&
                Objects.equals(authorUid, that.authorUid) &&
                Objects.equals(deliverables, that.deliverables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deliveryId, authorUid, deliverables);
    }

    @Override
    public String toString() {
        return "DeliveryRequest{" +
                "deliveryId='" + deliveryId + '\'' +
                ", authorUid='" + authorUid + '\'' +
                ", deliverables=" + deliverables +
                '}';
    }

    public static final class Builder {

        private String deliveryId;
        private String authorUid;
        private final List<DeliverableRequest> deliverables = new ArrayList<>();

        private Builder() {
        }

        public Builder deliveryId(String deliveryId) {
            this.deliveryId = deliveryId;
            return this;
        }

        public Builder authorUid(String authorUid) {
            this.authorUid = authorUid;
            return this;
        }

        public Builder addDeliverable(DeliverableRequest deliverable) {
            this.deliverables.add(deliverable);
            return this;
        }

        public DeliveryRequest build() {
            Preconditions.checkNotNull(deliveryId, "DeliveryId is required");
            Preconditions.checkNotNull(authorUid, "AuthorUid is required");
            return new DeliveryRequest(deliveryId, authorUid, deliverables);
        }

    }

}
